<x-app-layout>
    <x-slot name="header">
        @isset($organization)
            {{__('Edit Organization :name', ['name' => $organization->name])}}
        @else
            {{__('Create Organization')}}
        @endisset
    </x-slot>

    <x-slot name="actions">
        <x-link class="ml-auto" :href="\game_engine()->back_url()" icon="arrow-sm-left" color="secondary" size="sm">{{__('Back')}}</x-link>
    </x-slot>

    <x-container>
        <livewire:game-engine.admin.organizations.edit :organization="$organization ?? \game_engine()->organizationQuery()->make()"/>
    </x-container>

    @isset($organization)
        <x-container class="mt-4">
            <x-card>
                <x-slot name="header" class="!bg-gray-200 font-bold uppercase">
                    <x-icon name="users"/>&nbsp;{{trans_choice('User|Users', 2)}}
                </x-slot>
                <livewire:game-engine.admin.organizations.users.table :organization="$organization"/>
            </x-card>
        </x-container>

        <x-container class="mt-4">
            <x-game-engine::awards.manager :scope="$organization"/>
        </x-container>
    @endisset
</x-app-layout>
