<?php
/** @var \DefStudio\GameEngine\Models\Run $model */
?>

<div class="flex">
    @if($model->completed_at)
        @can('view', $model)
            <x-button class="mr-2" size="sm" color="secondary" icon="eye"
                      wire:click="$emit('openModal', 'game-engine.admin.runs.view', {{json_encode(['isModal' => true, 'run_id' => $model->id])}})"
            />
        @endcan
    @endif
    @can('delete', $model)
        <x-confirm-action title="Warning"
                          :content="__('Do you really want to delete this run?')"
                          :requires-password="true"
                          wire:then="delete({{$model->id}})"
                          class="ml-auto"
        >
            <x-button icon="trash" color="secondary" size="sm"/>
        </x-confirm-action>
    @endcan
</div>
