@php
    use DefStudio\GameEngine\Enums\MediaCollection
    /** @var \DefStudio\GameEngine\Http\Livewire\Missions\Edit $this */
@endphp


@php($cover_url = $this->mission->getFirstMediaUrl(MediaCollection::cover))
@php($placeholder_url = $this->mission->getFirstMediaUrl(MediaCollection::placeholder))
@php($placeholder_active_url = $this->mission->getFirstMediaUrl(MediaCollection::placeholder_active))
@php($placeholder_completed_url = $this->mission->getFirstMediaUrl(MediaCollection::placeholder_complete))
<x-card :collapsed="!empty($placeholder_url)">
    <x-slot name="header" class="!bg-gray-200 font-bold uppercase">
       <x-icon name="photo"/>&nbsp;{{__('Images')}}
    </x-slot>

    <div class="grid grid-cols-1 gap-6">
        <x-game-engine::livewire.image_field
            id="cover-image"
            model="cover_image"
            :label="__('Cover Image')"
            :uploaded-url="$cover_url"
            :helper="__('SVG, PNG or JPG')"
            remove-method="remove_cover_image"
        />

        <x-game-engine::livewire.image_field
            id="placeholder-image"
            model="placeholder_image"
            :label="__('Placeholder Image')"
            :uploaded-url="$placeholder_url"
            :helper="__('SVG, PNG or JPG')"
            remove-method="remove_placeholder_image"
        />

        <x-game-engine::livewire.image_field
            id="placeholder-image-active"
            model="placeholder_image_active"
            :label="__('Placeholder Image (when active)')"
            :uploaded-url="$placeholder_active_url"
            :helper="__('SVG, PNG or JPG')"
            remove-method="remove_placeholder_image_active"
        />

        <x-game-engine::livewire.image_field
            id="placeholder-image-completed"
            model="placeholder_image_completed"
            :label="__('Placeholder Image (when completed)')"
            :uploaded-url="$placeholder_completed_url"
            :helper="__('SVG, PNG or JPG')"
            remove-method="remove_placeholder_image_completed"
        />
    </div>
</x-card>
