@php
    use DefStudio\GameEngine\Models\Mission;
    use DefStudio\GameEngine\Enums\MediaCollection;

    /** @var Mission $mission */
@endphp

<x-card>
    @if($isModal)
        <x-slot name="header" class="!bg-gray-200 font-bold uppercase">
            @if($mission->exists)
                {{__('Edit Mission')}}
            @else
                {{__('Create Mission')}}
            @endif
        </x-slot>
    @endif


    <div @class([
            "grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-6"
        ])>

        <x-text model="mission.title" :label="__('Title')"/>


        <x-text-area class="col-span-1 md:col-span-2 lg:col-span-3" model="mission.description" :label="__('Description')"/>

        <x-checkbox :label="__('Hide when not active')"
                    model="mission.configuration.hide_when_not_active" defer
                    class="col-span-1 md:col-span-2 lg:col-span-3"/>
        <x-checkbox :label="__('Hide when completed')"
                    model="mission.configuration.hide_when_completed" defer
                    class="col-span-1 md:col-span-2 lg:col-span-3"/>
        <x-checkbox :label="__('Autocomplete on activation')"
                    model="mission.configuration.hide_when_completed" defer
                    class="col-span-1 md:col-span-2 lg:col-span-3"/>

        <div class="col-span-1 md:col-span-2 lg:col-span-3 space-y-6">
            <x-game-engine::livewire.missions.edit.assets/>

            <x-game-engine::livewire.missions.edit.tasks/>

            <x-game-engine::storytellings.manager class="mt-4" :target="$mission"/>

            <x-game-engine::awards.manager :scope="$mission"/>
        </div>
    </div>

    <x-slot name="actions">
        @if($this->isModal)

            <x-button class="mr-auto" wire:loading.disable color="secondary" wire:click="$emit('closeModal')">
                @if($mission->isDirty())
                    {{__('Abort')}}
                @else
                    {{__('Close')}}
                @endif
            </x-button>
        @endif

        <x-button wire:loading.disable wire:click="save">{{__('Save')}}</x-button>
    </x-slot>
</x-card>

