<?php

/** @noinspection PhpUnhandledExceptionInspection */

namespace DefStudio\GameEngine\Actions\Missions;

use DefStudio\Actions\Action;
use Illuminate\Support\Facades\Gate;
use DefStudio\GameEngine\Models\Mission;
use DefStudio\GameEngine\Enums\MediaCollection;
use DefStudio\GameEngine\Events\Missions\MissionPlaceholderImageActiveUpdated;

/**
 * @method static void run(Mission $mission)
 */
class RemovePlaceholderImageCompleted extends Action
{
    public function handle(Mission $mission): void
    {
        Gate::authorize('update', $mission);
        $mission->getFirstMedia(MediaCollection::placeholder_complete)?->delete();
        $mission->unsetRelation('media');

        MissionPlaceholderImageActiveUpdated::dispatch($mission);
    }
}
