<?php

namespace DefStudio\GameEngine\Actions\Users;

use Locale;
use DefStudio\Actions\Action;
use Barryvdh\TranslationManager\Models\Translation;

/**
 * @method static array<string, string> run()
 */
class FindAvailableLocales extends Action
{
    /**
     * @return array<string, string>
     */
    public function handle(): array
    {
        return Translation::select('locale')
            ->distinct()
            ->pluck('locale')
            ->push(config('app.locale'))
            ->push(config('app.fallback_locale'))
            ->filter()
            ->keyBy(fn(string $locale) => $locale)
            ->map(fn(string $locale): string => Locale::getDisplayLanguage($locale))
            ->toArray();
    }
}
