<?php

namespace DefStudio\GameEngine\Policies;

use DefStudio\GameEngine\Models\User;
use DefStudio\GameEngine\Enums\Permission;
use Illuminate\Auth\Access\HandlesAuthorization;

class UserPolicy
{
    use HandlesAuthorization;

    public function viewAny(User $user): bool
    {
        return $user->can(Permission::view_users->value);
    }

    public function view(User $user, User $target): bool
    {
        return $user->can(Permission::view_users->for_role(
            $target->get_role_in_organization($user->current_organization)
        ));
    }

    public function update(User $user, User $target): bool
    {
        return $user->can(Permission::edit_users->for_role(
            $target->get_role_in_organization($user->current_organization)
        ));
    }

    public function delete(User $user, User $target): bool
    {
        return $user->can(Permission::delete_users->for_role(
            $target->get_role_in_organization($user->current_organization)
        ));
    }

    public function impersonate(User $user, User $target): bool
    {
        if (!$user->can_impersonate()) {
            return false;
        }

        return $target->can_be_impersonated();
    }
}
