<?php

namespace DefStudio\GameEngine\Database\Factories;

use DefStudio\GameEngine\Enums\MediaCollection;
use Illuminate\Database\Eloquent\Factories\Factory;
use DefStudio\GameEngine\Database\Factories\Concerns\HasMedia;
use DefStudio\GameEngine\Database\Factories\Concerns\HasStorytelling;
use function game_engine;

class AwardFactory extends Factory
{
    use HasMedia;
    use HasStorytelling;

    public function modelName(): string
    {
        return game_engine()->awardClass();
    }

    public function definition(): array
    {
        return [
            'name' => fake()->sentence,
            'description' => fake()->realTextBetween(),
        ];
    }

    public function with_icon_image(): AwardFactory
    {
        return $this->with_media(MediaCollection::icon);
    }
}
