<?php

use DefStudio\GameEngine\Enums\Role;

?>


@props(['story'])

@php($user = game_engine()->user())

<x-card :padding="false">
    <x-slot name="header">
        {{$story->title}}
    </x-slot>

    @if($cover_url = $story->getFirstMediaUrl(\DefStudio\GameEngine\Enums\MediaCollection::cover, \DefStudio\GameEngine\Enums\MediaConversion::square))
        <img class="w-full" src="{{$cover_url}}">
    @endif

    <x-slot name="actions">
        @if(!$user->hasRole(Role::super_admin) && $user->completed_story($story) && \DefStudio\GameEngine\Enums\Feature::allow_replay->disabled())
            {{('Already Played')}}
        @else
            <x-link href="{{route('game-engine.play', $story)}}">{{__('Play')}}</x-link>
        @endif
    </x-slot>
</x-card>
