<?php

namespace DefStudio\GameEngine\Actions\Organizations;

use DefStudio\Actions\Action;
use Illuminate\Support\Facades\Gate;
use DefStudio\GameEngine\Models\Organization;

/**
 * @method static Organization run(Organization $organization)
 */
class SaveOrganization extends Action
{
    public function handle(Organization $organization): Organization
    {
        Gate::authorize('save', $organization);

        return tap($organization)->save();
    }
}
