<?php

use DefStudio\GameEngine\Enums\Role;
use DefStudio\GameEngine\Models\User;
use DefStudio\GameEngine\Models\Team;

/** @var User $model */
?>

<div class="flex">
    @can('update', $model)
        @php($route = route('game-engine.admin.users.edit', ['user' => $model]))
        <x-link icon="pencil" color="secondary" size="sm" :href="$route"/>
    @endcan

    <x-game-engine::impersonate :user="$model"/>

    @can('update', $team)
        @if($model->belongs_to_team($team))
            <x-button class="ml-auto" color="secondary" wire:click="unsubscribe({{$model->id}})" wire:loading.disable>{{__('Unsubscribe')}}</x-button>
        @else
            <x-button class="ml-auto" wire:click="subscribe({{$model->id}})" wire:loading.disable>{{__('Subscribe')}}</x-button>
        @endif
    @endcan
</div>
