<?php

namespace DefStudio\GameEngine\Http\Livewire\Runs;

use Illuminate\Contracts\View\View;
use LivewireUI\Modal\ModalComponent;
use Illuminate\Database\Eloquent\Collection;
use DefStudio\GameEngine\Models\Storytelling;
use DefStudio\GameEngine\Http\Livewire\Concerns\ImprovedModal;

class StorytellingModal extends ModalComponent
{
    use ImprovedModal;

    public string $scope;

    public string $type;

    public array $storytelling_ids;

    public function render(): View
    {
        return view('game-engine::livewire.runs.storytelling-modal');
    }

    public function getStorytellingsProperty(): Collection
    {
        return Storytelling::findMany($this->storytelling_ids);
    }

    public function complete(): void
    {
        $this->emit('complete_storytelling', $this->scope, $this->type, !$this->isModal);
    }
}
