<?php

namespace DefStudio\GameEngine\Policies;

use DefStudio\GameEngine\Models\User;
use DefStudio\GameEngine\Models\Storytelling;
use Illuminate\Auth\Access\HandlesAuthorization;

class StorytellingPolicy
{
    use HandlesAuthorization;

    public function view(User $user, Storytelling $storytelling): bool
    {
        return $user->can('view', $storytelling->target);
    }

    public function save(User $user, Storytelling $storytelling): bool
    {
        if ($storytelling->exists) {
            return $this->update($user, $storytelling);
        }

        return $this->create($user, $storytelling);
    }

    public function create(User $user, Storytelling $storytelling): bool
    {
        return $user->can('update', $storytelling->target);
    }

    public function update(User $user, Storytelling $storytelling): bool
    {
        return $user->can('update', $storytelling->target);
    }

    public function delete(User $user, Storytelling $storytelling): bool
    {
        return $user->can('update', $storytelling->target);
    }
}
