<?php

namespace DefStudio\GameEngine\Providers;

use Illuminate\Support\ServiceProvider;
use Illuminate\Database\Eloquent\Relations\Relation;

class MorphServiceProvider extends ServiceProvider
{
    public function boot(): void
    {
        Relation::enforceMorphMap([
            game_engine()->userMorphClass() => game_engine()->userClass(),
            game_engine()->organizationMorphClass() => game_engine()->organizationClass(),
            game_engine()->teamMorphClass() => game_engine()->teamClass(),
            game_engine()->storyMorphClass() => game_engine()->storyClass(),
            game_engine()->mapMorphClass() => game_engine()->mapClass(),
            game_engine()->missionMorphClass() => game_engine()->missionClass(),
            game_engine()->taskMorphClass() => game_engine()->taskClass(),
            game_engine()->storytellingMorphClass() => game_engine()->storytellingClass(),
            game_engine()->awardMorphClass() => game_engine()->awardClass(),
        ]);
    }
}
