<?php

namespace DefStudio\GameEngine\Commands;

use Illuminate\Console\Command;
use DefStudio\GameEngine\Enums\Role;
use DefStudio\GameEngine\Models\User;

class MakeSuperAdminCommand extends Command
{
    protected $signature = 'game-engine:make-super-admin {email?}';

    protected $description = 'Assign superpowers to an user';

    public function handle(): int
    {
        $email = $this->argument('email') ?? $this->ask('Enter email of user to promote to Super Admin');

        if (empty($email)) {
            $this->error('An email is needed to give superpowers');

            return self::FAILURE;
        }

        $user = \game_engine()->userQuery()->where('email', $email)->first();

        if (!$user instanceof User) {
            $this->error('User not found');

            return self::FAILURE;
        }

        $user->assignRole(Role::super_admin->name);

        $this->info('DONE. Remember: From great power comes great responsibility.');

        return self::SUCCESS;
    }
}
