<?php

/** @noinspection PhpUnhandledExceptionInspection */

namespace DefStudio\GameEngine\Actions\Storytellings;

use DefStudio\Actions\Action;
use Illuminate\Http\UploadedFile;
use Illuminate\Support\Facades\Gate;
use DefStudio\GameEngine\Models\Storytelling;
use DefStudio\GameEngine\Enums\MediaCollection;
use DefStudio\GameEngine\Events\Storytellings\StorytellingBackgroundImageUpdated;

/**
 * @method static void run(Storytelling $storytelling, UploadedFile $background_image_file)
 */
class StoreBackgroundImage extends Action
{
    public function handle(Storytelling $storytelling, UploadedFile $background_image_file): void
    {
        Gate::authorize('update', $storytelling);

        $storytelling->addMedia($background_image_file)
            ->toMediaCollection(MediaCollection::background->name);

        StorytellingBackgroundImageUpdated::dispatch($storytelling);
    }
}
