<?php

namespace DefStudio\GameEngine\Policies;

use DefStudio\GameEngine\Models\Task;
use DefStudio\GameEngine\Models\User;
use Illuminate\Auth\Access\HandlesAuthorization;
use DefStudio\GameEngine\Decorators\Tasks\TaskDecorator;

class TaskPolicy
{
    use HandlesAuthorization;

    public function view(User $user, Task|TaskDecorator $target): bool
    {
        return $user->can('view', $target->mission);
    }

    public function save(User $user, Task|TaskDecorator $target): bool
    {
        if ($target->exists) {
            return $this->update($user, $target);
        }

        return $this->create($user, $target);
    }

    public function create(User $user, Task|TaskDecorator $target): bool
    {
        return $user->can('update', $target->mission);
    }

    public function update(User $user, Task|TaskDecorator $target): bool
    {
        return $user->can('update', $target->mission);
    }

    public function delete(User $user, Task|TaskDecorator $target): bool
    {
        return $user->can('update', $target->mission);
    }
}
