<?php

use DefStudio\GameEngine\Models\User;
use DefStudio\GameEngine\Enums\Role;

/** @var User $model */
?>
<div class="flex flex-col">
    @if($model->hasRole(Role::super_admin))
        <div class="rounded text-black {{Role::super_admin->color()}} px-2 py-1 text-xs font-bold mr-3">
            {{Role::super_admin->label()}}
        </div>

    @endif
    @foreach($model->organizations as $organization)
        <div class="mt-1 flex items-center">
            <a href="{{route('game-engine.admin.organizations.edit', $organization)}}">
                {{$organization->name}}
            </a>
            @php($organization_role = Role::from($organization->pivot->role))
            <div class="ml-auto rounded text-black {{$organization_role->color()}} px-2 py-1 text-xs font-bold mr-3">
                {{$organization_role->label()}}
            </div>
        </div>
    @endforeach
</div>
