<?php
/*
 * Copyright (c) 2023. DEF STUDIO S.R.L. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are prohibited without the prior written permission of DEF STUDIO S.R.L.
 * This software is provided "as is" and any express or implied warranties, including,
 * but not limited to, the implied warranties of merchantability and fitness for a
 * particular purpose are disclaimed. In no event shall DEF STUDIO S.R.L. be liable
 * for any direct, indirect, incidental, special, exemplary, or consequential damages
 * (including, but not limited to, procurement of substitute goods or services;
 * loss of use, data, or profits; or business interruption) however caused and on any
 * theory of liability, whether in contract, strict liability, or tort (including negligence or
 * otherwise) arising in any way out of the use of this software, even if advised of the
 * possibility of such damage.
 */
/** @noinspection PhpUnhandledExceptionInspection */

/** @noinspection PhpPossiblePolymorphicInvocationInspection */

namespace DefStudio\GameEngine\Actions\Runs;

use DefStudio\Actions\Action;
use DefStudio\GameEngine\Models\Run;
use Illuminate\Support\Facades\Gate;
use DefStudio\GameEngine\Models\User;
use DefStudio\GameEngine\Models\Story;

/**
 * @method static Run run(Story $story, User $user)
 */
class GetActiveRun extends Action
{
    public function handle(Story $story, User $user): ?Run
    {
        return $this->active_run_if_exists($story, $user);
    }

    public function find_or_create(Story $story, User $user): Run
    {
        Gate::forUser($user)->authorize('play', $story);

        $run = $this->active_run_if_exists($story, $user);

        if ($run instanceof Run) {
            return $run;
        }

        return CreateRun::run($user, $story);
    }

    private function active_run_if_exists(Story $story, User $user): ?Run
    {
        $run = game_engine()->runQuery()
            ->forUser($user)
            ->ofStory($story)
            ->active()
            ->first();

        $run?->setRelation('user', $user);
        $run?->setRelation('story', $story);

        return $run;
    }
}
