<?php
/*
 * Copyright (c) 2023. DEF STUDIO S.R.L. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are prohibited without the prior written permission of DEF STUDIO S.R.L.
 * This software is provided "as is" and any express or implied warranties, including,
 * but not limited to, the implied warranties of merchantability and fitness for a
 * particular purpose are disclaimed. In no event shall DEF STUDIO S.R.L. be liable
 * for any direct, indirect, incidental, special, exemplary, or consequential damages
 * (including, but not limited to, procurement of substitute goods or services;
 * loss of use, data, or profits; or business interruption) however caused and on any
 * theory of liability, whether in contract, strict liability, or tort (including negligence or
 * otherwise) arising in any way out of the use of this software, even if advised of the
 * possibility of such damage.
 */

/** @noinspection PhpUndefinedMethodInspection */

namespace DefStudio\GameEngine\Database\Factories;

use DefStudio\GameEngine\Enums\MediaCollection;
use Illuminate\Database\Eloquent\Factories\Factory;
use DefStudio\GameEngine\Database\Factories\Concerns\HasMedia;
use DefStudio\GameEngine\Database\Factories\Concerns\DefinesAwards;
use DefStudio\GameEngine\Database\Factories\Concerns\HasStorytelling;

class MissionFactory extends Factory
{
    use DefinesAwards;
    use HasMedia;
    use HasStorytelling;

    public function modelName(): string
    {
        return \game_engine()->missionClass();
    }

    public function definition(): array
    {
        return [
            'title' => fake()->sentence,
            'description' => fake()->text,
            'map_id' => game_engine()->mapClass()::factory(),
            'pos_x' => fake()->numberBetween(0, 1024),
            'pos_y' => fake()->numberBetween(0, 1080),
        ];
    }

    public function with_cover_image(string $path = null): MissionFactory
    {
        return $this->with_media(MediaCollection::cover, $path);
    }

    public function with_background_image(string $path = null): MissionFactory
    {
        return $this->with_media(MediaCollection::background, $path);
    }

    public function with_placeholder_image(string $path = null): MissionFactory
    {
        return $this->with_media(MediaCollection::placeholder, $path);
    }

    public function with_placeholder_active_image(string $path = null): MissionFactory
    {
        return $this->with_media(MediaCollection::placeholder_active, $path);
    }

    public function with_placeholder_completed_image(string $path = null): MissionFactory
    {
        return $this->with_media(MediaCollection::placeholder_completed, $path);
    }
}
