/*
 * Copyright (c) 2023. DEF STUDIO S.R.L. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification, are prohibited without the prior written permission of DEF STUDIO S.R.L. This software is provided "as is" and any express or implied warranties, including, but not limited to, the implied warranties of merchantability and fitness for a particular purpose are disclaimed. In no event shall DEF STUDIO S.R.L. be liable for any direct, indirect, incidental, special, exemplary, or consequential damages (including, but not limited to, procurement of substitute goods or services; loss of use, data, or profits; or business interruption) however caused and on any theory of liability, whether in contract, strict liability, or tort (including negligence or otherwise) arising in any way out of the use of this software, even if advised of the possibility of such damage.
 */

// noinspection JSUnresolvedReference,JSUnusedGlobalSymbols

document.addEventListener('alpine:init', () => {

    // noinspection JSUnresolvedReference
    Alpine.data('task_drag_and_drop_run', () => ({
        size: {w: 0, h: 0, zoom: 1},
        dragging: {mouse_x: null, mouse_y: null},
        snaps: null,
        options: {repositioning_allowed: false, partial_submit_allowed: false, loose_snaps: true},
        tiles_count: null,
        tries_count: 0,
        placements: {},
        submitting: false,
        initialize(config) {
            this.snaps = config.snaps;
            this.options = config.options;
            this.tiles_count = this.snaps.length;

            this.$nextTick(() => {
                this.update_zoom();
            });
        },
        update_zoom() {
            this.size.w = this.$refs.base_image.naturalWidth;
            this.size.h = this.$refs.base_image.naturalHeight;

            const real_w = this.$refs.base_image.clientWidth;
            const real_h = this.$refs.base_image.clientHeight;

            const zoom_w = real_w / this.size.w;
            const zoom_h = real_h / this.size.h;

            this.size.zoom = Math.min(zoom_w, zoom_h);

            console.log('[drag and drop] zoom = ', this.size.zoom)

            if(!this.size.zoom || this.size.zoom === Infinity){
                setTimeout(() => this.update_zoom(), 500);
            }
        },
        drag_start(e) {
            this.dragging.mouse_x = e.offsetX;
            this.dragging.mouse_y = e.offsetY;
            e.dataTransfer.effectAllowed = 'move';
        },
        drag_end(tile_id, e) {
            if (!this.options.repositioning_allowed && this.placements[tile_id]) {
                return;
            }

            const drop_location = this.get_drop_location(e);
            const snap = this.get_snap(drop_location);

            if (!snap && !this.options.loose_snaps) {
                return;
            }

            this.tries_count++;

            this.placements[tile_id] = snap ?? drop_location;

            this.$refs.container.appendChild(e.target);

            if (this.check_complete() && !this.options.repositioning_allowed) {
                this.submit();
            }
        },
        get_drop_location(e) {
            const image_offset_x = Math.round(this.$refs.base_image.getBoundingClientRect().left);
            const image_offset_y = Math.round(this.$refs.base_image.getBoundingClientRect().top);

            const drop_offset_x = e.clientX - this.dragging.mouse_x;
            const drop_offset_y = e.clientY - this.dragging.mouse_y;

            const drop_x = drop_offset_x - image_offset_x;
            const drop_y = drop_offset_y - image_offset_y;

            return {x: drop_x/this.size.zoom, y: drop_y/this.size.zoom}
        },
        get_snap(drop_location) {
            for (const snap of this.snaps) {
                if (drop_location.x < snap.x - snap.distance) {
                    continue;
                }
                if (drop_location.x > snap.x + snap.distance) {
                    continue;
                }
                if (drop_location.y < snap.y - snap.distance) {
                    continue;
                }
                if (drop_location.y > snap.y + snap.distance) {
                    continue;
                }

                return snap;
            }

            return null;
        },
        check_complete() {
            return Object.keys(this.placements).length === this.tiles_count;
        },
        submit() {
            this.submitting = true;
            this.$wire.call('complete_task_with_result', {
                placements: this.placements,
                tries_count: this.tries_count,
            });
        },
    }));
});
