<x-card>
    @if($isModal)
        <x-slot name="header" class="!bg-gray-200 font-bold uppercase">
            @if($map->exists)
                {{__('Edit Map')}}
            @else
                {{__('Create Map')}}
            @endif
        </x-slot>
    @endif


    <div @class([
            "grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 ",
            'gap-6' => $editing
        ])>
        @if($editing)
            <x-text model="map.title" defer :label="__('Title')"/>
            <x-text-area class="col-span-1 md:col-span-2 lg:col-span-3" model="map.description" defer :label="__('Description')"/>

            <x-game-engine::livewire.image_field
                id="background_image"
                model="background_image"
                class="col-span-1 md:col-span-2 lg:col-span-3"
                :label="$map->exists ? __('Replace Background Image') : __('Background Image')"
                :helper="__('SVG, PNG or JPG')"
                :uploaded-url="$map->getFirstMediaUrl(\DefStudio\GameEngine\Enums\MediaCollection::background)"
                remove-method="remove_background_image"
            />
        @else
            <h2 class="text-xl text-gray-700">{{$map->title}}</h2>
            <div class="text-gray-500 col-span-1 lg:col-span-3">{{$map->description}}</div>
        @endif
    </div>

    <x-slot name="actions">
        @if($this->isModal)
            <x-button class="mr-auto" wire:loading.disable color="secondary" wire:click="$emit('closeModal')">{{__('Abort')}}</x-button>
        @elseif($editing && $map->exists)
            <x-button class="mr-auto" wire:loading.disable color="secondary" wire:click="$set('editing', false)">{{__('Abort')}}</x-button>
        @endif

        @if($editing)
            <x-button wire:loading.disable wire:click="save">{{__('Save')}}</x-button>
        @else
            <x-button color="secondary" wire:loading.disable wire:click="$set('editing', true)">{{__('Edit')}}</x-button>
        @endif
    </x-slot>
</x-card>

