<?php

namespace DefStudio\GameEngine\Http\Livewire\Runs\Concerns;

use Livewire\Event;

trait OpensModals
{
    protected function open_modal(string $modal, array $params): void
    {
        $this->eventQueue = array_filter($this->eventQueue, fn(Event $event): bool => $event->serialize()['event'] !== 'closeModal');
        $this->emit('openModal', $modal, $params);
    }

    protected function close_modal(): void
    {
        if (collect($this->eventQueue)->filter(fn(Event $event) => $event->serialize()['event'] === 'openModal')->isNotEmpty()) {
            return;
        }

        $this->emit('closeModal', true);
    }
}
