<?php

namespace DefStudio\GameEngine\Models\Concerns;

use DefStudio\GameEngine\Models\Award;
use Illuminate\Database\Eloquent\Model;
use DefStudio\GameEngine\Actions\Awards\DeleteAward;
use Illuminate\Database\Eloquent\Relations\MorphMany;
use DefStudio\GameEngine\Models\Contracts\AwardsDefiner;

trait DefinesAwards
{
    public function awards(): MorphMany
    {
        return $this->morphMany(game_engine()->awardClass(), 'scope');
    }

    public static function bootDefinesAwards(): void
    {
        self::deleting(function(AwardsDefiner&Model $model): void {
            $model->loadMissing('awards');
            $model->awards->each(fn(Award $award) => DeleteAward::run($award));
        });
    }
}
