@php
    use DefStudio\GameEngine\Enums\MediaCollection;
    /** @var \DefStudio\GameEngine\Http\Livewire\Tasks\Edit $this */
@endphp

@php($background_url = $this->task->getFirstMediaUrl(MediaCollection::background))

<x-card {{$attributes}} :collapsed="true">
    <x-slot name="header" class="!bg-gray-200 font-bold uppercase">
        <x-icon name="photo"/>&nbsp;{{trans_choice('Image|Images', 2)}}
    </x-slot>

    <div class="grid grid-cols-1 gap-6">
        <x-game-engine::livewire.image_field
            id="background-image"
            model="background_image"
            :label="trans_choice('Background Image|Background Images', 1)"
            :uploaded-url="$background_url"
            :helper="__('SVG, PNG or JPG')"
            remove-method="remove_background_image"
        />
    </div>
</x-card>
