<?php

namespace DefStudio\GameEngine\DTO\Missions;

use DefStudio\GameEngine\Models\Mission;
use Illuminate\Contracts\Support\Arrayable;
use DefStudio\GameEngine\Enums\MediaCollection;

class Placeholder implements Arrayable
{
    public int $id;

    public int $pos_x;

    public int $pos_y;

    public string $placeholder_image;

    public function __construct(array|Mission $data)
    {
        if (is_array($data)) {
            $this->id = $data['id'];
            $this->pos_x = $data['pos_x'];
            $this->pos_y = $data['pos_y'];
            $this->placeholder_image = $data['placeholder_image'];
        } else {
            $this->id = $data->id;
            $this->pos_x = $data->pos_x;
            $this->pos_y = $data->pos_y;
            $this->placeholder_image = $data->getFirstMediaUrl(MediaCollection::placeholder);
        }
    }

    /**
     * @return array{id: int, pos_x: int, pos_y: int, placeholder_image: string}
     */
    public function toArray(): array
    {
        return [
            'id' => $this->id,
            'pos_x' => $this->pos_x,
            'pos_y' => $this->pos_y,
            'placeholder_image' => $this->placeholder_image,
        ];
    }
}
