<?php

namespace DefStudio\GameEngine\Middleware;

use Closure;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\App;
use DefStudio\GameEngine\Models\User;

use function game_engine;

class SetUserLocale
{
    public function handle(Request $request, Closure $next): mixed
    {
        $user = game_engine()->user(true);

        if ($user instanceof User) {
            App::setLocale($user->locale);
        }

        return $next($request);
    }
}
