<?php
/*
 * Copyright (c) 2023. DEF STUDIO S.R.L. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are prohibited without the prior written permission of DEF STUDIO S.R.L.
 * This software is provided "as is" and any express or implied warranties, including,
 * but not limited to, the implied warranties of merchantability and fitness for a
 * particular purpose are disclaimed. In no event shall DEF STUDIO S.R.L. be liable
 * for any direct, indirect, incidental, special, exemplary, or consequential damages
 * (including, but not limited to, procurement of substitute goods or services;
 * loss of use, data, or profits; or business interruption) however caused and on any
 * theory of liability, whether in contract, strict liability, or tort (including negligence or
 * otherwise) arising in any way out of the use of this software, even if advised of the
 * possibility of such damage.
 */

/** @noinspection PhpUnhandledExceptionInspection */

namespace DefStudio\GameEngine\Http\Controllers;

use Illuminate\Contracts\View\View;
use DefStudio\GameEngine\Enums\Permission;
use DefStudio\GameEngine\Models\Organization;
use DefStudio\GameEngine\Actions\Runs\GetActiveRun;
use Illuminate\Foundation\Auth\Access\AuthorizesRequests;
use function game_engine;

class RunsController
{
    use AuthorizesRequests;

    public function index(): View
    {

        $this->authorize(Permission::view_runs->value);

        return view('game-engine::admin.runs.index');
    }

    public function play(int $story): View
    {
        /** @var Organization $organization */
        $organization = game_engine()->organizationQuery()->findOrFail(game_engine()->user()->current_organization_id);
        $story = $organization->stories()->findOrFail($story);

        $this->authorize('play', $story);

        $run = GetActiveRun::make()->find_or_create($story, game_engine()->user());

        $this->authorize('play', $run);

        return view('game-engine::stories.play', ['run' => $run]);
    }

    public function run(int $run): View
    {
        $run = game_engine()->user()->available_runs()
            ->findOrFail($run);

        $this->authorize('play', $run);

        return view('game-engine::stories.play', ['run' => $run]);
    }
}
