<?php
/*
 * Copyright (c) 2023. DEF STUDIO S.R.L. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are prohibited without the prior written permission of DEF STUDIO S.R.L.
 * This software is provided "as is" and any express or implied warranties, including,
 * but not limited to, the implied warranties of merchantability and fitness for a
 * particular purpose are disclaimed. In no event shall DEF STUDIO S.R.L. be liable
 * for any direct, indirect, incidental, special, exemplary, or consequential damages
 * (including, but not limited to, procurement of substitute goods or services;
 * loss of use, data, or profits; or business interruption) however caused and on any
 * theory of liability, whether in contract, strict liability, or tort (including negligence or
 * otherwise) arising in any way out of the use of this software, even if advised of the
 * possibility of such damage.
 */

/** @noinspection PhpUnhandledExceptionInspection */

namespace DefStudio\GameEngine\Actions\Missions;

use DefStudio\Actions\Action;
use Illuminate\Support\Facades\Gate;
use DefStudio\GameEngine\Models\Mission;
use DefStudio\GameEngine\Enums\MediaCollection;
use DefStudio\GameEngine\Events\Missions\MissionBackgroundImageUpdated;

/**
 * @method static void run(Mission $mission)
 */
class RemoveBackgroundImage extends Action
{
    public function handle(Mission $mission): void
    {
        Gate::authorize('update', $mission);
        $mission->getFirstMedia(MediaCollection::background)?->delete();
        $mission->unsetRelation('media');

        MissionBackgroundImageUpdated::dispatch($mission);
    }
}
