<?php

/** @noinspection PhpUnhandledExceptionInspection */

namespace DefStudio\GameEngine\Actions\Storytellings;

use DefStudio\Actions\Action;
use Illuminate\Support\Facades\Gate;
use DefStudio\GameEngine\Models\Storytelling;
use DefStudio\GameEngine\Enums\MediaCollection;
use DefStudio\GameEngine\Events\Storytellings\StorytellingAvatarImageUpdated;

/**
 * @method static void run(Storytelling $storytelling)
 */
class RemoveAvatarImage extends Action
{
    public function handle(Storytelling $story): void
    {
        Gate::authorize('update', $story);

        $story->getFirstMedia(MediaCollection::avatar)?->delete();
        $story->unsetRelation('media');

        StorytellingAvatarImageUpdated::dispatch($story);
    }
}
