<?php
/*
 * Copyright (c) 2023. DEF STUDIO S.R.L. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are prohibited without the prior written permission of DEF STUDIO S.R.L.
 * This software is provided "as is" and any express or implied warranties, including,
 * but not limited to, the implied warranties of merchantability and fitness for a
 * particular purpose are disclaimed. In no event shall DEF STUDIO S.R.L. be liable
 * for any direct, indirect, incidental, special, exemplary, or consequential damages
 * (including, but not limited to, procurement of substitute goods or services;
 * loss of use, data, or profits; or business interruption) however caused and on any
 * theory of liability, whether in contract, strict liability, or tort (including negligence or
 * otherwise) arising in any way out of the use of this software, even if advised of the
 * possibility of such damage.
 */

namespace DefStudio\GameEngine\Decorators\Runs;

use Illuminate\Support\Collection;
use DefStudio\GameEngine\Models\Map;
use DefStudio\GameEngine\Models\Mission;

/**
 * @extends PlayableActivity<Map>
 *
 * @mixin Map
 */
class PlayableMap extends PlayableActivity
{
    public static string $state_key = 'maps';

    public function playable_story(): PlayableStory
    {
        $this->loadMissing('story');

        return PlayableStory::build($this->story)->setup($this->run);
    }

    /**
     * @return Collection<int, PlayableMission>
     */
    public function playable_missions(): Collection
    {
        return $this->missions
            ->map(fn(Mission|PlayableMission $mission) => PlayableMission::build($mission)->setup($this->run));
    }

    protected function setup_decorator(): void
    {
        $this->model->loadMissing(['media', 'storytellings', 'missions']);
    }

    public function completed(): bool
    {
        return $this->playable_missions()->every(fn(PlayableMission $mission) => $mission->completed());
    }
}
