<?php
/*
 * Copyright (c) 2023. DEF STUDIO S.R.L. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are prohibited without the prior written permission of DEF STUDIO S.R.L.
 * This software is provided "as is" and any express or implied warranties, including,
 * but not limited to, the implied warranties of merchantability and fitness for a
 * particular purpose are disclaimed. In no event shall DEF STUDIO S.R.L. be liable
 * for any direct, indirect, incidental, special, exemplary, or consequential damages
 * (including, but not limited to, procurement of substitute goods or services;
 * loss of use, data, or profits; or business interruption) however caused and on any
 * theory of liability, whether in contract, strict liability, or tort (including negligence or
 * otherwise) arising in any way out of the use of this software, even if advised of the
 * possibility of such damage.
 */

/** @noinspection PhpUnhandledExceptionInspection */

namespace DefStudio\GameEngine\Actions\Runs;

use DefStudio\Actions\Action;
use DefStudio\GameEngine\Enums\Role;
use DefStudio\GameEngine\Models\Run;
use DefStudio\GameEngine\Models\User;
use DefStudio\GameEngine\Models\Story;
use DefStudio\GameEngine\Enums\Feature;
use DefStudio\GameEngine\Exceptions\StoryException;

/**
 * @method static Run run(User $user, Story $story)
 */
class CreateRun extends Action
{
    public function handle(User $user, Story $story): Run
    {
        $run = $this->without_save($user, $story);
        $run->save();

        return $run;
    }

    public function without_save(User $user, Story $story): Run
    {
        if ($user->has_active_story($story) && Feature::allow_replay->disabled()) {
            throw_unless($user->hasRole(Role::super_admin), StoryException::already_played($user, $story));
        }

        $run = game_engine()->runQuery()->make([
            'user_id' => $user->id,
            'story_id' => $story->id,
        ]);

        $run->setRelation('user', $user);
        $run->setRelation('story', $story);

        return $run;
    }
}
