<?php

namespace DefStudio\GameEngine\Policies;

use DefStudio\GameEngine\Enums\Role;
use DefStudio\GameEngine\Models\User;
use DefStudio\GameEngine\Enums\Permission;

class RolePolicy
{
    public function create(User $user, Role $role): bool
    {
        if ($user->can(Permission::create_users->value)) {
            return true;
        }

        return $user->can(Permission::create_users->for_role($role));
    }
}
