@php
    /** @var \Livewire\Component $this */

@endphp

@props([
    'id' => "file-uploader-".rand(),
    'model',
    'uploadedUrl' => null,
    'label' => null,
    'helper' => null,
    'removeMethod' => '$refresh'
])

@php($uploading = $this->getPropertyValue($model))
@if(empty($uploading) && empty($uploadedUrl))
    <!--suppress HtmlRequiredAltAttribute -->
    <x-game-engine::livewire.file-uploader :id="$id"
                                           :model="$model"
                                           :label="$label"
                                           :helper="$helper"
                                           {{$attributes}}
    />
@elseif($uploading?->getMimeType() || $uploadedUrl)
    <div {{$attributes->class('relative')}}>
        <label class='block font-medium text-sm text-gray-700'>
            {{$label}}
        </label>
        <img id="{{$id}}-preview" x-ref="{{$id}}_preview" src="{{$uploading && $uploading->isPreviewable() ? $uploading->temporaryUrl() :  $uploadedUrl}}">

        <div class="absolute bottom-2 right-2">
            <x-button x-data
                      color="secondary"
                      @click="$wire.set('{{$model}}', null)"
                      wire:click="{{$removeMethod}}"
                      wire:loading.disable
                      icon="trash"
                      size="sm"
            />
        </div>
    </div>
@endif
