@props([
    'model',
    'label' => null,
    'id' => "file-uploader-".rand(),
    'helper' => null,
])

<div {{$attributes}}>
    @if($label)
        <label class='block font-medium text-sm text-gray-700'>
            {{$label}}
        </label>
    @endif
    <!--suppress UnnecessaryLabelJS, CommaExpressionJS, JSUnresolvedReference -->
    <div x-data="{dropping: false, handle_file_drop(e){
            if (e.dataTransfer.files.length > 0) {
                const file = e.dataTransfer.files[0];
                console.log('upload');
                @this.upload('{{$model}}', file);
            }
        }}" class="flex items-center justify-center w-full">

        <label x-on:drop="dropping = false"
               x-on:drop.prevent="handle_file_drop($event)"
               x-on:dragover.prevent="dropping = true"
               x-on:dragleave.prevent="dropping = false"
               for="dropzone-file-{{$id}}"
               class="flex flex-col items-center justify-center w-full h-64
                      hover:bg-gray-100
                      dark:hover:bg-gray-600
                      border-2 border-dashed rounded-lg cursor-pointer
                      dark:hover:border-gray-500

                      drop:bg-gray-100 drop:border-gray-500 drop:dark:bg-gray-600 drop:dark:border-gray-500"
        >

            <div class="flex flex-col items-center justify-center pt-5 pb-6">
                <svg aria-hidden="true" class="w-10 h-10 mb-3 text-gray-400" fill="none" stroke="currentColor" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M7 16a4 4 0 01-.88-7.903A5 5 0 1115.9 6L16 6a5 5 0 011 9.9M15 13l-3-3m0 0l-3 3m3-3v12"></path>
                </svg>

                <p wire:loading.remove wire.target="{{$model}}" class="mb-2 text-sm text-gray-500 dark:text-gray-400">
                    <span class="font-semibold">{{__('Click to upload')}}</span> {{'or drag and drop'}}
                </p>

                <div class="mt-1" wire:loading.flex wire.target="{{$model}}">
                    <svg class="animate-spin -ml-1 mr-3 h-5 w-5 text-gray-700" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24">
                        <circle class="opacity-25" cx="12" cy="12" r="10" stroke="currentColor" stroke-width="4"></circle>
                        <path class="opacity-75" fill="currentColor" d="M4 12a8 8 0 018-8V0C5.373 0 0 5.373 0 12h4zm2 5.291A7.962 7.962 0 014 12H0c0 3.042 1.135 5.824 3 7.938l3-2.647z"></path>
                    </svg>
                    <div>Processing...</div>
                </div>

                @if($helper)
                    <p class="text-xs text-gray-500 dark:text-gray-400">{{$helper}}</p>
                @endif

                <input id="dropzone-file-{{$id}}" wire:model="{{$model}}" type="file" class="hidden"/>
            </div>
        </label>
        @error($model)
        <p class="text-xs text-red-500">{{$message}}</p>
        @enderror
    </div>


</div>
