<?php

namespace DefStudio\GameEngine\Policies;

use DefStudio\GameEngine\Models\Map;
use DefStudio\GameEngine\Models\User;
use Illuminate\Auth\Access\HandlesAuthorization;

class MapPolicy
{
    use HandlesAuthorization;

    public function view(User $user, Map $target): bool
    {
        return $user->can('view', $target->story);
    }

    public function save(User $user, Map $target): bool
    {
        if ($target->exists) {
            return $this->update($user, $target);
        }

        return $this->create($user, $target);
    }

    public function create(User $user, Map $target): bool
    {
        return $user->can('update', $target->story);
    }

    public function update(User $user, Map $target): bool
    {
        return $user->can('update', $target->story);
    }

    public function delete(User $user, Map $target): bool
    {
        return $user->can('update', $target->story);
    }
}
