<?php
/*
 * Copyright (c) 2023. DEF STUDIO S.R.L. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are prohibited without the prior written permission of DEF STUDIO S.R.L.
 * This software is provided "as is" and any express or implied warranties, including,
 * but not limited to, the implied warranties of merchantability and fitness for a
 * particular purpose are disclaimed. In no event shall DEF STUDIO S.R.L. be liable
 * for any direct, indirect, incidental, special, exemplary, or consequential damages
 * (including, but not limited to, procurement of substitute goods or services;
 * loss of use, data, or profits; or business interruption) however caused and on any
 * theory of liability, whether in contract, strict liability, or tort (including negligence or
 * otherwise) arising in any way out of the use of this software, even if advised of the
 * possibility of such damage.
 */

// config for DefStudio/GameEngine

use DefStudio\GameEngine\Enums\Role;
use DefStudio\GameEngine\Models\Map;
use DefStudio\GameEngine\Models\Run;
use DefStudio\GameEngine\Models\Task;
use DefStudio\GameEngine\Models\Team;
use DefStudio\GameEngine\Models\Award;
use DefStudio\GameEngine\Models\Story;
use DefStudio\GameEngine\Enums\Feature;
use DefStudio\GameEngine\Models\Mission;
use DefStudio\GameEngine\Decorators\Tasks;
use DefStudio\GameEngine\Enums\Permission;
use DefStudio\GameEngine\Models\Organization;
use DefStudio\GameEngine\Models\Storytelling;
use DefStudio\GameEngine\Enums\StorytellingType;
use DefStudio\GameEngine\Actions\Missions\DefaultTaskExtractor;

return [
    'route_prefix' => 'game-engine',
    'users' => [
        'morph_class' => 'user',
        'roles' => [
            Role::super_admin->value => [
                'color' => 'bg-orange-500',
            ],
            Role::admin->value => [
                'color' => 'bg-red-500',
                'permissions' => [
                    Permission::view_users->for_role(Role::admin),
                    Permission::view_users->for_role(Role::master),
                    Permission::view_users->for_role(Role::player),
                    Permission::create_users->for_role(Role::master),
                    Permission::create_users->for_role(Role::player),
                    Permission::edit_users->for_role(Role::master),
                    Permission::edit_users->for_role(Role::player),
                    Permission::delete_users->for_role(Role::master),
                    Permission::delete_users->for_role(Role::player),

                    Permission::view_organizations->value,
                    Permission::edit_organizations->value,

                    Permission::view_teams->value,
                    Permission::create_teams->value,
                    Permission::edit_teams->value,
                    Permission::delete_teams->value,

                    Permission::view_stories->value,
                    Permission::create_stories->value,
                    Permission::edit_stories->value,
                    Permission::delete_stories->value,

                    Permission::manage_awards->value,

                    Permission::view_runs->value,
                    Permission::delete_runs->value,
                ],
            ],
            Role::master->value => [
                'color' => 'bg-blue-500',
                'permissions' => [
                    Permission::view_teams->value,
                    Permission::edit_teams->value,

                    Permission::view_stories->value,

                    Permission::view_runs->value,
                    Permission::delete_runs->value,
                ],
            ],
            Role::player->value => [
                'color' => 'bg-purple-500',
                'permissions' => [

                ],
            ],
        ],
    ],
    'organizations' => [
        'model' => Organization::class,
        'table' => 'organizations',
        'subscriptions_table' => 'organization_user',
        'morph_class' => 'organization',
    ],
    'teams' => [
        'model' => Team::class,
        'table' => 'teams',
        'subscriptions_table' => 'team_user',
        'morph_class' => 'team',
    ],
    'stories' => [
        'model' => Story::class,
        'table' => 'stories',
        'subscriptions_table' => 'story_subscriptions',
        'morph_class' => 'story',
    ],
    'maps' => [
        'model' => Map::class,
        'table' => 'maps',
        'morph_class' => 'map',
    ],
    'missions' => [
        'model' => Mission::class,
        'table' => 'missions',
        'morph_class' => 'mission',
        'task_extractor' => DefaultTaskExtractor::class,
    ],
    'tasks' => [
        'model' => Task::class,
        'table' => 'tasks',
        'morph_class' => 'task',
        'types' => [
            Tasks\MultipleChoiceQuestion::class,
            Tasks\DragAndDrop::class,
        ],
    ],
    'storytelling' => [
        'model' => Storytelling::class,
        'table' => 'storytellings',
        'morph_class' => 'storytelling',
        'types' => [
            StorytellingType::activation,
            StorytellingType::prologue,
            StorytellingType::epilogue,
        ],
        'available_in' => [
            Story::class,
            Map::class,
            Mission::class,
            // Task::class,
        ],
    ],
    'awards' => [
        'model' => Award::class,
        'table' => 'awards',
        'morph_class' => 'award',
        'scopes' => [
            Organization::class,
            Story::class,
            Map::class,
            Mission::class,
        ],
    ],
    'runs' => [
        'model' => Run::class,
        'morph_class' => 'run',
        'table' => 'runs',
        'awards_engine' => \DefStudio\GameEngine\Actions\Runs\DefaultAwardsEngine::class,
        'level_engine' => \DefStudio\GameEngine\Actions\Runs\DefaultLevelEngine::class,
        'timers' => [
            'max_tick_duration_seconds' => \Carbon\CarbonInterval::minutes(10)->totalSeconds,
        ],
    ],
    'features' => [
        //Users
        Feature::teams,
        Feature::multi_language,
        Feature::impersonate,
        Feature::welcome_email,

        //Stories
        Feature::storytelling,
        Feature::tag_system,
        Feature::user_stories,
        Feature::team_stories,
        Feature::allow_replay,

        //Awards
        Feature::levels_system,
        Feature::awards_system,
        Feature::awards_hierarchy,
        Feature::scoped_awards,
    ],
    'assets' => [
        'admin' => [
            'js' => [
                'vendor/game-engine/ckeditor.js',
                'vendor/game-engine/livewire-sortable.js',
            ],
            'css' => [
                'vendor/game-engine/ckeditor.css',
                'vendor/game-engine/styles.css',
            ],
        ],
        'runner' => [
            'js' => [
                'vendor/game-engine/tasks.js',
            ],
            'css' => [
                'vendor/game-engine/ckeditor.css',
                'vendor/game-engine/styles.css',
            ],
        ],
    ],
];
