<?php

namespace DefStudio\GameEngine\Actions\Awards;

use DefStudio\Actions\Action;
use Illuminate\Support\Facades\Gate;
use DefStudio\GameEngine\Models\Award;
use DefStudio\GameEngine\Events\Awards\AwardDeleted;

/**
 * @method static Award run(Award $award)
 */
class DeleteAward extends Action
{
    public function handle(Award $award): Award
    {
        Gate::authorize('delete', $award);

        $award->delete();

        AwardDeleted::dispatch($award);

        return $award;
    }
}
