@php
    use DefStudio\GameEngine\Actions\Runs\ComputeActivityTime;
    $locale = game_engine()->user()->locale ?? config('app.locale');
@endphp

@props(['label', 'activity', 'state_key', 'bgcolor', 'awards', 'run', 'padding' => 0])

@php($state = $run->get_state($state_key.".".$activity['id']))

<tr {{$attributes->class('odd:bg-white even:bg-gray-50')}}>
    <td class="pl-{{$padding}} pr-2 py-1 font-medium whitespace-nowrap text-left text-gray-800 text-sm">
        <x-game-engine::elements.marked-box :shadow="false" :bgcolor="$bgcolor">
            {{$label}}: {{$activity['title']}}
        </x-game-engine::elements.marked-box>
    </td>
    <td class="px-2 py-1 font-medium whitespace-nowrap text-left text-gray-800 text-sm">
        {{ComputeActivityTime::run($state['timers'] ?? [])->cascade()->locale($locale)->forHumans()}}
    </td>
    <x-game-engine::livewire.runs.view.table.award-cells
        class="px-2 py-1 font-medium whitespace-nowrap text-left text-gray-800 text-sm"
        :awards="$awards" :state="$state"
    />
</tr>
