{{--@formatter:off--}}
@component('mail::message')
# {{__('Welcome to :app_name', ['app_name' => config('app.name')])}}

{{__('Hi :name', ['name' => $user->name])}}

{{__("You have been subscribed to :app_name, below you'll find your credentials", ['app_name' => config('app.name')])}}

<x-mail::panel>

{{__('Email :email', ['email' => $user->email])}}

@if($password)
{{__('Password :password', ['password' => $password])}}

<x-mail::button :url="config('app.url')">
{{__('Enter')}}
</x-mail::button>
@else

@php
if(config('game-engine.users.reset_password.url_validity_days')){
    $password_reset_url = \Illuminate\Support\Facades\URL::temporarySignedRoute('game-engine.reset-password', today()->endOfDay()->addDays(config('game-engine.users.reset_password.url_validity_days')), ['user' => $user]);
}else{
    $password_reset_url = \Illuminate\Support\Facades\URL::signedRoute('game-engine.reset-password', ['user' => $user]);
}
@endphp

<x-mail::button :url="$password_reset_url">
{{__('Configure your password')}}
</x-mail::button>
@endif

</x-mail::panel>

{{__('Enjoy your journey, sincerely,')}}<br>
{{ config('app.name') }}
@endcomponent
