<?php
/*
 * Copyright (c) 2023. DEF STUDIO S.R.L. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification, are prohibited without the prior written permission of DEF STUDIO S.R.L. This software is provided "as is" and any express or implied warranties, including, but not limited to, the implied warranties of merchantability and fitness for a particular purpose are disclaimed. In no event shall DEF STUDIO S.R.L. be liable for any direct, indirect, incidental, special, exemplary, or consequential damages (including, but not limited to, procurement of substitute goods or services; loss of use, data, or profits; or business interruption) however caused and on any theory of liability, whether in contract, strict liability, or tort (including negligence or otherwise) arising in any way out of the use of this software, even if advised of the possibility of such damage.
 */ /*
 * Copyright (c) 2023. DEF STUDIO S.R.L. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are prohibited without the prior written permission of DEF STUDIO S.R.L.
 * This software is provided "as is" and any express or implied warranties, including,
 * but not limited to, the implied warranties of merchantability and fitness for a
 * particular purpose are disclaimed. In no event shall DEF STUDIO S.R.L. be liable
 * for any direct, indirect, incidental, special, exemplary, or consequential damages
 * (including, but not limited to, procurement of substitute goods or services;
 * loss of use, data, or profits; or business interruption) however caused and on any
 * theory of liability, whether in contract, strict liability, or tort (including negligence or
 * otherwise) arising in any way out of the use of this software, even if advised of the
 * possibility of such damage.
 */ /** @noinspection PhpUnhandledExceptionInspection */

namespace DefStudio\GameEngine\Http\Livewire\Stories;

use DefStudio\WiredTables\WiredTable;
use DefStudio\GameEngine\Models\Story;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Relations\Relation;
use DefStudio\WiredTables\Configurations\TableConfiguration;
use DefStudio\GameEngine\Models\Contracts\SubscribesToStories;

abstract class SubscriptionsTable extends WiredTable
{
    public SubscribesToStories $subscriber;

    protected function configure(TableConfiguration $configuration): void
    {
        $configuration
            ->pageSize(10)
            ->groupFilters(false);
    }

    protected function filters(): void
    {
        $this->filter(__('Display'), 'display')
            ->select(['subscribed' => __('Display Active'), 'available' => __('Display Available')])
            ->placeholder(__('Display All Stories'))
            ->handle($this->active_filter(...));
    }

    protected function columns(): void
    {
        $this->column(__('Title'), 'title')->searchable()->sortable();
        $this->column(trans_choice('Action|Actions', 2))->view('game-engine::livewire.admin.stories.subscription-table.actions', ['subscriber' => $this->subscriber]);
    }

    public function unsubscribe(int $story_id): void
    {
        /** @var Story $story */
        $story = game_engine()->storyQuery()->findOrFail($story_id);

        $this->subscriber->unsubscribe_from_story($story);
    }

    public function subscribe(int $story_id): void
    {
        $this->subscriber->stories_feature()->enforce();

        /** @var Story $story */
        $story = game_engine()->storyQuery()->findOrFail($story_id);

        $this->subscriber->subscribe_to_story($story);
    }

    /**
     * @param  Builder<Story>|Relation<Story>  $query
     * @param  'subscribed'|'available'  $display
     */
    abstract protected function active_filter(Builder|Relation $query, string $display): void;
}
