<?php

/** @noinspection PhpUnhandledExceptionInspection */

namespace DefStudio\GameEngine\Actions\Missions;

use DefStudio\Actions\Action;
use Illuminate\Support\Facades\Gate;
use DefStudio\GameEngine\Models\Mission;
use DefStudio\GameEngine\Enums\MediaCollection;
use DefStudio\GameEngine\Events\Missions\MissionPlaceholderImageUpdated;

/**
 * @method static void run(Mission $mission)
 */
class RemovePlaceholderImage extends Action
{
    public function handle(Mission $mission): void
    {
        Gate::authorize('update', $mission);
        $mission->getFirstMedia(MediaCollection::placeholder)?->delete();
        $mission->unsetRelation('media');

        MissionPlaceholderImageUpdated::dispatch($mission);
    }
}
