<?php
/*
 * Copyright (c) 2023. DEF STUDIO S.R.L. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are prohibited without the prior written permission of DEF STUDIO S.R.L.
 * This software is provided "as is" and any express or implied warranties, including,
 * but not limited to, the implied warranties of merchantability and fitness for a
 * particular purpose are disclaimed. In no event shall DEF STUDIO S.R.L. be liable
 * for any direct, indirect, incidental, special, exemplary, or consequential damages
 * (including, but not limited to, procurement of substitute goods or services;
 * loss of use, data, or profits; or business interruption) however caused and on any
 * theory of liability, whether in contract, strict liability, or tort (including negligence or
 * otherwise) arising in any way out of the use of this software, even if advised of the
 * possibility of such damage.
 */

use Illuminate\Support\Facades\Route;
use DefStudio\GameEngine\Middleware\AdminMiddleware;
use DefStudio\GameEngine\Http\Controllers\MapsController;
use DefStudio\GameEngine\Http\Controllers\RunsController;
use DefStudio\GameEngine\Http\Controllers\TeamsController;
use DefStudio\GameEngine\Http\Controllers\UsersController;
use DefStudio\GameEngine\Http\Controllers\AwardsController;
use DefStudio\GameEngine\Http\Controllers\StoriesController;
use DefStudio\GameEngine\Http\Controllers\OrganizationsController;

if (class_exists("Laravel\Jetstream\Http\Middleware\AuthenticateSession")) {
    $main_middleware = ['web', 'auth:sanctum', "Laravel\Jetstream\Http\Middleware\AuthenticateSession", 'verified'];
} else {
    $main_middleware = ['auth'];
}

Route::middleware($main_middleware)->group(function () {

    Route::name('game-engine.')->prefix(config('game-engine.route_prefix') ?? '')->group(function () {
        Route::get('dashboard', fn () => view('game-engine::dashboard'))->name('dashboard');

        Route::get('play/{story_id}', [RunsController::class, 'play'])->name('play');

        Route::get('organizations/{organization}/switch', [OrganizationsController::class, 'switch'])->name('organizations.switch');

        Route::name('admin.')->prefix('admin')->middleware(AdminMiddleware::class)->group(function () {
            Route::get('users/create', [UsersController::class, 'create'])->name('users.create');
            Route::resource('users', UsersController::class)->only(['index', 'edit']);

            Route::resource('organizations', OrganizationsController::class)->only(['index', 'create', 'edit']);

            Route::resource('teams', TeamsController::class)->only(['index', 'create', 'edit']);

            Route::resource('stories', StoriesController::class)->only(['index', 'create', 'edit']);

            Route::get('stories/{story}/maps/{map}/edit', [MapsController::class, 'edit'])->name('maps.edit');

            Route::resource('awards', AwardsController::class)->only(['index']);

            Route::resource('runs', RunsController::class)->only(['index']);
        });
    });
});
