<?php

namespace DefStudio\GameEngine\Providers;

use DefStudio\GameEngine\Enums\Role;
use Illuminate\Support\Facades\Gate;
use DefStudio\GameEngine\Models\User;
use DefStudio\GameEngine\Policies\MapPolicy;
use DefStudio\GameEngine\Policies\RolePolicy;
use DefStudio\GameEngine\Policies\TaskPolicy;
use DefStudio\GameEngine\Policies\TeamPolicy;
use DefStudio\GameEngine\Policies\UserPolicy;
use DefStudio\GameEngine\Policies\AwardPolicy;
use DefStudio\GameEngine\Policies\StoryPolicy;
use DefStudio\GameEngine\Policies\MissionPolicy;
use DefStudio\GameEngine\Policies\OrganizationPolicy;
use DefStudio\GameEngine\Policies\StorytellingPolicy;
use DefStudio\GameEngine\Decorators\Tasks\TaskDecorator;
use Illuminate\Foundation\Support\Providers\AuthServiceProvider as ServiceProvider;
use function game_engine;

class AuthServiceProvider extends ServiceProvider
{
    public function boot(): void
    {
        $this->app->bind(User::class, game_engine()->userClass());

        Gate::before(function($user, $ability): ?bool {
            if ($ability === 'impersonate') {
                return null;
            }

            return $user->hasRole(Role::super_admin) ? true : null;
        });
    }

    public function policies(): array
    {
        return [
            game_engine()->userClass() => UserPolicy::class,
            game_engine()->teamClass() => TeamPolicy::class,
            game_engine()->organizationClass() => OrganizationPolicy::class,
            game_engine()->storyClass() => StoryPolicy::class,
            game_engine()->mapClass() => MapPolicy::class,
            game_engine()->missionClass() => MissionPolicy::class,
            game_engine()->taskClass() => TaskPolicy::class,
            game_engine()->storytellingClass() => StorytellingPolicy::class,
            game_engine()->awardClass() => AwardPolicy::class,
            TaskDecorator::class => TaskPolicy::class,
            Role::class => RolePolicy::class,
        ];
    }
}
