# Game Engine Core

[![Latest Version on Packagist](https://img.shields.io/packagist/v/defstudio/game-engine.svg?style=flat-square)](https://packagist.org/packages/defstudio/game-engine)
[![GitHub Tests Action Status](https://img.shields.io/github/actions/workflow/status/defstudio/game-engine/run-tests.yml?branch=main&label=tests&style=flat-square)](https://github.com/defstudio/game-engine/actions?query=workflow%3Arun-tests+branch%3Amain)
[![GitHub Code Style Action Status](https://img.shields.io/github/actions/workflow/status/defstudio/game-engine/fix-php-code-style-issues.yml?branch=main&label=code%20style&style=flat-square)](https://github.com/defstudio/game-engine/actions?query=workflow%3A"Fix+PHP+code+style+issues"+branch%3Amain)
[![Total Downloads](https://img.shields.io/packagist/dt/defstudio/game-engine.svg?style=flat-square)](https://packagist.org/packages/defstudio/game-engine)

This is where your description should go. Limit it to a paragraph or two. Consider adding a small example.

## Support us

[<img src="https://github-ads.s3.eu-central-1.amazonaws.com/game-engine.jpg?t=1" width="419px" />](https://spatie.be/github-ad-click/game-engine)

We invest a lot of resources into creating [best in class open source packages](https://spatie.be/open-source). You can support us by [buying one of our paid products](https://spatie.be/open-source/support-us).

We highly appreciate you sending us a postcard from your hometown, mentioning which of our package(s) you are using. You'll find our address on [our contact page](https://spatie.be/about-us). We publish all received postcards on [our virtual postcard wall](https://spatie.be/open-source/postcards).

## Installation

You can install the package via composer:

```bash
composer require defstudio/game-engine
```

1. setup jetstream
2. setup spatie/permissions
3. setup barryvdh/translations
4. publish the config file with:

```bash
php artisan vendor:publish --tag="game-engine-config"
```


5. update `database/seeders/DatabaseSeeder` to include roles update command

```php
class DatabaseSeeder extends Seeder
{
    public function run(): void
    {
        Artisan::call('game-engine:sync-roles');
    }
}
```

6. publish and run the migrations with:

```bash
php artisan vendor:publish --tag="game-engine-migrations"
php artisan migrate
``` 



You must publish assets using

```bash
php artisan vendor:publish --tag="game-engine-assets" --force
```

and cofigure composer.json for updating assets after running `composer update` command:

```json
 "scripts": {
        "post-autoload-dump": [
           ...
        ],
        "post-update-cmd": [
            ...
            "@php artisan vendor:publish --tag=game-engine-assets --ansi --force"
        ],
  ...
```

finally, add a script component at the end of your main layout view:

```html
<x-game-engine::scripts/>

```


Optionally, you can publish the views using

```bash
php artisan vendor:publish --tag="game-engine-views"
```

## Scripts

Game Engine needs a `@stack('scripts')` blade directive to be present in page layout


## Testing

```bash
composer test
```

## Changelog

Please see [CHANGELOG](CHANGELOG.md) for more information on what has changed recently.

## Contributing

Please see [CONTRIBUTING](CONTRIBUTING.md) for details.

## Security Vulnerabilities

Please review [our security policy](../../security/policy) on how to report security vulnerabilities.

## Credits

- [Fabio Ivona](https://github.com/fabio-ivona)
- [All Contributors](../../contributors)

## License

The MIT License (MIT). Please see [License File](LICENSE.md) for more information.
