@props(['storytellings', 'callback'])

@php
    use DefStudio\GameEngine\Models\Storytelling;
    use Illuminate\Database\Eloquent\Collection;
    /** @var Collection<int, Storytelling> $storytellings */
@endphp

<div x-data="{
        current: 1,
        total: {{$storytellings->count()}},
        next(){
            if(this.current === this.total)
            {
                {!! $callback !!}
                return;
            }

            this.current++;
        }
    }">

    <x-game-engine::runs.storytelling.box {{$attributes}}>
        @foreach($storytellings as $storytelling)
            <div class="relative grow flex flex-col" x-show="current === {{$loop->iteration}}" x-cloak>

                @php($background = $storytelling->getFirstMedia(\DefStudio\GameEngine\Enums\MediaCollection::background))
                @php($avatar = $storytelling->getFirstMedia(\DefStudio\GameEngine\Enums\MediaCollection::avatar))

                @if($background)
                    <img src="{{$background->getUrl()}}" class="rounded-md">
                @endif

                <div class="absolute bottom-0 right-0 left-0 flex px-2">
                    @if($avatar && $storytelling->avatar_position === 'left')
                        <x-game-engine::runs.storytelling.avatar :avatar="$avatar"/>
                    @endif

                    <x-game-engine::runs.storytelling.text class="mt-auto mb-2">
                        <div class="ck-content">
                            {!! $storytelling->text !!}
                        </div>

                        <x-game-engine::runs.elements.button-primary @click="next()" class="ml-auto">
                            {{__('Next')}}
                        </x-game-engine::runs.elements.button-primary>
                    </x-game-engine::runs.storytelling.text>

                    @if($avatar && $storytelling->avatar_position === 'right')
                        <x-game-engine::runs.storytelling.avatar :avatar="$avatar"/>
                    @endif
                </div>
            </div>
        @endforeach
    </x-game-engine::runs.storytelling.box>
</div>

