@props(['available_tags'])

@if(\DefStudio\GameEngine\Enums\Feature::tag_system->enabled())
    <div {{$attributes}}>
      <x-card :collapsed="true">
          <x-slot name="header" class="!bg-gray-200 font-bold uppercase">
              <x-icon name="tag"/>&nbsp;{{__('Tags')}}
          </x-slot>

          <div class="flex">
              @foreach($available_tags as $tag_category => $config)
                  <div wire:key="tag_category_{{$tag_category}}">
                      <div class="font-bold">{{$config['label']}}</div>
                      @foreach($config['tags'] as $tag_id => $tag_label)
                          <div wire:key="tag_{{$tag_category}}_{{$tag_label}}">
                              <x-checkbox id="tag_{{$tag_category}}_{{$tag_label}}_checkbox" model="tags" value="{{$tag_category}}:{{$tag_id}}" :label="$tag_label"/>
                          </div>
                      @endforeach
                  </div>
              @endforeach
          </div>
      </x-card>
    </div>
@endif
