@php
    use DefStudio\GameEngine\Enums\Role;
    /** @var \DefStudio\GameEngine\Models\Story $model */
@endphp

<div class="flex">
    @can('update', $model)
        <x-link icon="pencil" color="secondary" size="sm" :href="route('game-engine.admin.stories.edit', ['story' => $model])"/>
    @endcan
    @can('delete', $model)
        <x-confirm-action class="ml-auto" title="Warning"
                          :content="__('Do you really want to delete this story?')"
                          :requires-password="true"
                          wire:then="delete({{$model->id}})"
        >
            <x-button icon="trash" color="secondary" size="sm"/>
        </x-confirm-action>
    @endcan
</div>
