<?php

namespace DefStudio\GameEngine\Actions\Missions;

use Illuminate\Support\Collection;
use DefStudio\GameEngine\Models\Run;
use DefStudio\GameEngine\Models\Mission;
use DefStudio\GameEngine\Actions\Missions\Contracts\TaskExtractor;

class DefaultTaskExtractor implements TaskExtractor
{
    private int|null $seed = null;

    /**
     * {@inheritDoc}
     */
    public function extract(Run $run, Mission $mission): Collection
    {
        return $mission->tasks
            ->when(
                $mission->should_randomize_tasks_order(),
                fn(Collection $tasks) => $tasks->shuffle($this->seed)
            )->when(
                $mission->max_tasks_to_show(),
                fn(Collection $tasks, int $max) => $tasks->take($max)
            );
    }

    public function task_tags(): array
    {
        return [
            'level' => [
                'label' => __('Difficulty'),
                'tags' => [
                    0 => __('Easy'),
                    1 => __('Medium'),
                    2 => __('Hard'),
                ],
            ],
        ];
    }

    public function with_seed(int|null $seed): static
    {
        $this->seed = $seed;

        return $this;
    }
}
