<?php

namespace DefStudio\GameEngine\Http\Livewire\Runs\Concerns;

use DefStudio\GameEngine\Models\Story;
use DefStudio\GameEngine\Enums\Feature;
use DefStudio\GameEngine\Enums\StorytellingType;
use DefStudio\GameEngine\Decorators\ModelDecorator;
use DefStudio\GameEngine\Models\Contracts\WithStorytelling;

/**
 * @property-read Story $story
 */
trait RunsStory
{
    public function mountRunsStory(): void
    {
        $this->setup_storytellings($this->story);
    }

    protected function complete_storytelling_runs_story(string|ModelDecorator|WithStorytelling $scope, StorytellingType|string $type): void
    {
        $type = StorytellingType::build_from($type);
        $scope = $this->get_storytelling_scope($scope);

        if ($scope !== 'story') {
            return;
        }

        if ($type === StorytellingType::activation && !$this->show_storytelling($scope, StorytellingType::prologue)) {
            $this->next_map();

            return;
        }

        if ($type === StorytellingType::prologue) {
            $this->next_map();

            return;
        }

        if ($type === StorytellingType::epilogue) {
            $this->complete_story();
        }
    }

    public function getStoryProperty(): Story
    {
        return $this->run->story;
    }

    public function start(): void
    {
        if (Feature::levels_system) {
            game_engine()->level_engine()->compute_starting_level($this->run);
        }

        if (Feature::points_system) {
            game_engine()->points_engine()->compute_starting_points($this->run);
        }

        if ($this->is_map_active()) {
            $this->call_traits_method('start');

            return;
        }

        if ($this->show_storytelling($this->story, StorytellingType::activation, StorytellingType::prologue)) {
            return;
        }

        $this->next_map();
    }

    protected function complete_story(): void
    {
        if ($this->show_storytelling($this->story, StorytellingType::epilogue)) {
            return;
        }

        if (Feature::points_system) {
            game_engine()->points_engine()->assign_points($this->run, $this->story);
        }

        if (Feature::levels_system) {
            game_engine()->level_engine()->assign_level($this->run, $this->story);
        }

        $this->emit('story:completed');
    }
}
